/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.ShowViewAction;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class MindMapViewsMenu
extends ContributionItem {
    private IWorkbenchWindow window;
    protected boolean dirty = true;
    private IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            manager.markDirty();
            MindMapViewsMenu.this.dirty = true;
        }
    };

    public MindMapViewsMenu(IWorkbenchWindow window) {
        this.window = window;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDynamic() {
        return true;
    }

    public void fill(Menu menu, int index) {
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).addMenuListener(this.menuListener);
        }
        if (!this.dirty) {
            return;
        }
        MenuManager manager = new MenuManager();
        this.fillMenu(manager);
        IContributionItem[] items = manager.getItems();
        if (items.length > 0) {
            int i = 0;
            while (i < items.length) {
                items[i].fill(menu, index++);
                ++i;
            }
        }
        this.dirty = false;
    }

    private void fillMenu(MenuManager manager) {
        IViewDescriptor[] views;
        IViewRegistry viewRegistry = this.window.getWorkbench().getViewRegistry();
        IViewDescriptor[] iViewDescriptorArray = views = viewRegistry.getViews();
        int n = views.length;
        int n2 = 0;
        while (n2 < n) {
            IViewDescriptor view = iViewDescriptorArray[n2];
            String viewId = view.getId();
            if (viewId.startsWith("org.xmind.ui.")) {
                this.addShowViewAction(manager, viewId, view);
            }
            ++n2;
        }
    }

    private void addShowViewAction(MenuManager manager, String viewId, IViewDescriptor view) {
        manager.add((IAction)new ShowViewAction2(this.window, view, false));
    }

    private static class ShowViewAction2
    extends ShowViewAction {
        protected ShowViewAction2(IWorkbenchWindow window, IViewDescriptor desc, boolean makeFast) {
            super(window, desc, makeFast);
        }
    }
}

