/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Menu;
import org.xmind.core.ITopic;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.gef.ISourceProvider;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.command.ICommandStack;
import org.xmind.ui.commands.AddMarkerCommand;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.DeleteMarkerCommand;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MarkerImageDescriptor;

public class GroupMarkers
extends ContributionItem {
    private ISelectionProvider selectionProvider;
    private IMarkerRef sourceMarkerRef;

    public GroupMarkers() {
        this.setId("org.xmind.ui.markerGroup");
    }

    public void setSelectionProvider(ISelectionProvider selectionProvider) {
        this.selectionProvider = selectionProvider;
    }

    public boolean isVisible() {
        return this.sourceMarkerRef != null;
    }

    public void setSourceMarkerRef(IMarkerRef sourceMarkerRef) {
        this.sourceMarkerRef = sourceMarkerRef;
    }

    public boolean isDynamic() {
        return true;
    }

    public void fill(Menu menu, int index) {
        IMarkerGroup group;
        if (this.sourceMarkerRef == null) {
            return;
        }
        ITopic topic = this.sourceMarkerRef.getParent();
        String sourceMarkerId = this.sourceMarkerRef.getMarkerId();
        IMarker sourceMarker = topic.getOwnedWorkbook().getMarkerSheet().findMarker(sourceMarkerId);
        if (sourceMarker != null && (group = sourceMarker.getParent()) != null) {
            for (IMarker marker : group.getMarkers()) {
                String targetMarkerId = marker.getId();
                new ActionContributionItem((IAction)new ReplaceMarkerAction(topic, sourceMarkerId, targetMarkerId)).fill(menu, index++);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReplaceMarkerAction
    extends Action {
        private ITopic topic;
        private String sourceMarkerId;
        private String targetMarkerId;

        public ReplaceMarkerAction(ITopic topic, String sourceMarkerId, String targetMarkerId) {
            this.topic = topic;
            this.sourceMarkerId = sourceMarkerId;
            this.targetMarkerId = targetMarkerId;
            this.setText(topic.getOwnedSheet().getLegend().getMarkerDescription(targetMarkerId));
            this.setImageDescriptor(MarkerImageDescriptor.createFromMarker(topic.getOwnedWorkbook().getMarkerSheet().findMarker(targetMarkerId)));
            boolean sameMarker = sourceMarkerId.equals(targetMarkerId);
            this.setEnabled(!sameMarker);
            this.setChecked(sameMarker);
        }

        public void run() {
            ICommandStack cs;
            if (!this.isEnabled()) {
                return;
            }
            IWorkbookRef wr = MindMapUI.getWorkbookRefManager().findRef(this.topic.getOwnedWorkbook());
            if (wr != null && (cs = wr.getCommandStack()) != null) {
                Command cmd = this.createReplaceMarkerCommand();
                cs.execute(cmd);
                if (cmd instanceof ISourceProvider) {
                    this.select(((ISourceProvider)cmd).getSources());
                }
            }
        }

        private void select(List<Object> sources) {
            if (GroupMarkers.this.selectionProvider != null) {
                GroupMarkers.this.selectionProvider.setSelection((ISelection)new StructuredSelection(sources));
            }
        }

        private Command createReplaceMarkerCommand() {
            return new CompoundCommand(CommandMessages.Command_ReplaceMarker, new Command[]{new DeleteMarkerCommand(this.topic, this.sourceMarkerId), new AddMarkerCommand(this.topic, this.targetMarkerId)});
        }
    }
}

