/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.gef.EditDomain;
import org.xmind.gef.Request;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.MarkerImageDescriptor;

public class AllMarkersMenu
extends MenuManager {
    private IGraphicalEditorPage page;

    public AllMarkersMenu() {
        super(MindMapMessages.Markers_text, "org.xmind.ui.allMarkers");
        this.setRemoveAllWhenShown(true);
        this.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AllMarkersMenu.this.fillMenu(manager);
            }
        });
    }

    public void setActivePage(IGraphicalEditorPage page) {
        this.page = page;
    }

    private void fillMenu(IMenuManager menu) {
        this.fillMarkerSheet(MindMapUI.getResourceManager().getSystemMarkerSheet(), menu);
    }

    private void fillMarkerSheet(IMarkerSheet sheet, IMenuManager menu) {
        for (IMarkerGroup group : sheet.getMarkerGroups()) {
            MenuManager groupMenu = new MenuManager(group.getName(), "#" + group.getId());
            this.fillGroup(group, (IMenuManager)groupMenu);
            menu.add((IContributionItem)groupMenu);
        }
    }

    private void fillGroup(IMarkerGroup group, IMenuManager menu) {
        for (IMarker marker : group.getMarkers()) {
            menu.add((IAction)new MarkerAction(marker));
        }
    }

    private class MarkerAction
    extends Action {
        private IMarker marker;

        public MarkerAction(IMarker marker) {
            this.marker = marker;
            this.setId("#" + marker.getId());
            this.setText(marker.getName());
            this.setImageDescriptor(MarkerImageDescriptor.createFromMarker(marker));
        }

        public void run() {
            if (AllMarkersMenu.this.page == null) {
                return;
            }
            EditDomain domain = AllMarkersMenu.this.page.getEditDomain();
            if (domain == null) {
                return;
            }
            domain.handleRequest(new Request("add marker").setParameter("markerId", (Object)this.marker.getId()));
        }
    }
}

