/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.xmind.ui.mindmap.INumberFormat;
import org.xmind.ui.mindmap.INumberFormatDescriptor;
import org.xmind.ui.mindmap.INumberFormatManager;
import org.xmind.ui.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberFormatExtensionManager
extends RegistryReader
implements INumberFormatManager {
    private Map<String, NumberFormatProxy> formats = null;
    private List<INumberFormatDescriptor> list = null;

    NumberFormatExtensionManager() {
    }

    protected boolean readElement(IConfigurationElement element) {
        String name = element.getName();
        if ("format".equals(name)) {
            this.readFormat(element);
            return true;
        }
        return false;
    }

    private void readFormat(IConfigurationElement element) {
        NumberFormatProxy proxy;
        try {
            proxy = new NumberFormatProxy(element);
        }
        catch (CoreException e) {
            Logger.log(e, "Failed to load numbering format: " + element);
            return;
        }
        if (this.formats == null) {
            this.formats = new HashMap<String, NumberFormatProxy>();
        }
        this.formats.put(proxy.getId(), proxy);
        if (this.list == null) {
            this.list = new ArrayList<INumberFormatDescriptor>();
        }
        this.list.add(proxy);
    }

    private void ensureLoaded() {
        if (this.formats != null && this.list != null) {
            return;
        }
        this.lazyLoad();
        if (this.formats == null) {
            this.formats = Collections.emptyMap();
        }
        if (this.list == null) {
            this.list = Collections.emptyList();
        }
    }

    private void lazyLoad() {
        this.readRegistry(Platform.getExtensionRegistry(), "org.xmind.ui", "numberFormats");
    }

    @Override
    public INumberFormatDescriptor getDescriptor(String formatId) {
        this.ensureLoaded();
        return this.formats.get(formatId);
    }

    @Override
    public List<INumberFormatDescriptor> getDescriptors() {
        this.ensureLoaded();
        return this.list;
    }

    @Override
    public INumberFormat getFormat(String formatId) {
        this.ensureLoaded();
        return this.formats.get(formatId);
    }

    @Override
    public String getNumberText(String formatId, int index) {
        INumberFormat format = this.getFormat(formatId);
        if (format != null) {
            return format.getText(index);
        }
        return null;
    }

    private static class NumberFormatProxy
    implements INumberFormat,
    INumberFormatDescriptor {
        private IConfigurationElement element;
        private String id;
        private String name;
        private String description;
        private INumberFormat implementation;
        private boolean failedInitImplementation = false;

        public NumberFormatProxy(IConfigurationElement element) throws CoreException {
            this.element = element;
            this.id = element.getAttribute("id");
            this.name = element.getAttribute("name");
            this.description = element.getAttribute("description");
            if (NumberFormatExtensionManager.getClassValue((IConfigurationElement)element, (String)"class") == null) {
                throw new CoreException((IStatus)new Status(4, element.getNamespaceIdentifier(), 0, "Invalid extension (missing class name): " + this.id, null));
            }
        }

        private INumberFormat getImplementation() {
            if (this.implementation == null && !this.failedInitImplementation) {
                try {
                    this.implementation = (INumberFormat)this.element.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    Logger.log(e, "Failed to create number format from class: " + NumberFormatExtensionManager.getClassValue((IConfigurationElement)this.element, (String)"class"));
                    this.failedInitImplementation = true;
                }
            }
            return this.implementation;
        }

        public String getText(int index) {
            INumberFormat impl = this.getImplementation();
            if (impl != null) {
                return impl.getText(index);
            }
            return null;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

