/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.decorations;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.decoration.IShadowedDecoration;
import org.xmind.gef.draw2d.decoration.PathConnectionDecoration;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.ui.decorations.IBranchConnectionDecoration;

public abstract class AbstractBranchConnection
extends PathConnectionDecoration
implements IBranchConnectionDecoration,
IShadowedDecoration {
    private int sourceOrientation = 0;
    private int targetOrientation = 0;
    private int sourceExpansion = 0;
    private int targetExpansion = 0;
    private boolean tapered = false;
    private boolean taperedStateChanged = false;

    protected AbstractBranchConnection() {
    }

    protected AbstractBranchConnection(String id) {
        super(id);
    }

    public void paintShadow(IFigure figure, Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        this.checkValidation(figure);
        graphics.setAlpha(this.getAlpha());
        graphics.setForegroundColor(ColorConstants.black);
        graphics.setLineWidth(this.getLineWidth());
        graphics.setLineStyle(this.getLineStyle());
        this.drawLine(figure, graphics);
    }

    protected void reroute(IFigure figure, PrecisionPoint sourcePos, PrecisionPoint targetPos, boolean validating) {
        this.calculateTerminalPoints(figure, sourcePos, targetPos);
        this.calculateControlPoints(figure, sourcePos, targetPos);
    }

    protected void calculateControlPoints(IFigure figure, PrecisionPoint sourcePos, PrecisionPoint targetPos) {
    }

    protected void calculateTerminalPoints(IFigure figure, PrecisionPoint sourcePos, PrecisionPoint targetPos) {
        IAnchor sa = this.getSourceAnchor();
        IAnchor ta = this.getTargetAnchor();
        int so = this.getSourceOrientation();
        int to = this.getTargetOrientation();
        if (so == 0 && to == 0) {
            if (sa != null) {
                if (ta != null) {
                    sourcePos.setLocation(sa.getLocation(ta.getReferencePoint(), (double)this.getSourceExpansion()));
                } else {
                    sourcePos.setLocation(sa.getLocation(0.0, 0.0, (double)this.getSourceExpansion()));
                }
            }
            if (ta != null) {
                if (sa != null) {
                    targetPos.setLocation(ta.getLocation(sa.getReferencePoint(), (double)this.getTargetExpansion()));
                } else {
                    targetPos.setLocation(ta.getLocation(0.0, 0.0, (double)this.getTargetExpansion()));
                }
            }
        } else if (so == 0) {
            if (ta != null) {
                targetPos.setLocation(ta.getLocation(to, (double)this.getTargetExpansion()));
            }
            if (sa != null) {
                sourcePos.setLocation(sa.getLocation(targetPos, (double)this.getSourceExpansion()));
            }
        } else if (to == 0) {
            if (sa != null) {
                sourcePos.setLocation(sa.getLocation(so, (double)this.getSourceExpansion()));
            }
            if (ta != null) {
                targetPos.setLocation(ta.getLocation(sourcePos, (double)this.getTargetExpansion()));
            }
        } else {
            if (sa != null) {
                sourcePos.setLocation(sa.getLocation(so, (double)this.getSourceExpansion()));
            }
            if (ta != null) {
                targetPos.setLocation(ta.getLocation(to, (double)this.getTargetExpansion()));
            }
        }
    }

    public int getSourceOrientation() {
        return this.sourceOrientation;
    }

    public int getTargetOrientation() {
        return this.targetOrientation;
    }

    public void setSourceOrientation(IFigure figure, int orientation) {
        if (orientation == this.sourceOrientation) {
            return;
        }
        this.sourceOrientation = orientation;
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
        this.invalidate();
    }

    public void setTargetOrientation(IFigure figure, int orientation) {
        if (orientation == this.targetOrientation) {
            return;
        }
        this.targetOrientation = orientation;
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
        this.invalidate();
    }

    public int getSourceExpansion() {
        return this.sourceExpansion;
    }

    public int getTargetExpansion() {
        return this.targetExpansion;
    }

    public void setSourceExpansion(IFigure figure, int expansion) {
        if (expansion == this.sourceExpansion) {
            return;
        }
        this.sourceExpansion = expansion;
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
        this.invalidate();
    }

    public void setTargetExpansion(IFigure figure, int expansion) {
        if (expansion == this.targetExpansion) {
            return;
        }
        this.targetExpansion = expansion;
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
        this.invalidate();
    }

    public boolean isTapered() {
        return this.tapered;
    }

    public void setTapered(IFigure figure, boolean tapered) {
        if (tapered == this.tapered) {
            return;
        }
        this.tapered = tapered;
        if (figure != null) {
            this.repaint(figure);
        }
        this.taperedStateChanged = true;
        this.invalidate();
    }

    protected boolean isPositionValid() {
        return super.isPositionValid() && !this.taperedStateChanged;
    }

    public void validate(IFigure figure) {
        this.taperedStateChanged = false;
        super.validate(figure);
    }

    protected boolean usesFill() {
        return this.isTapered();
    }

    protected double getThickLineWidth() {
        return this.getLineWidth() * 5;
    }

    protected void calcTaperedPositions(PrecisionPoint p1, PrecisionPoint p2, double amountFromP1ToP2, PrecisionPoint result1, PrecisionPoint result2) {
        this.calcTaperedPositions(p1, p2, amountFromP1ToP2, 5.0, result1, result2);
    }

    protected void calcTaperedPositions(PrecisionPoint p1, PrecisionPoint p2, double amountFromP1ToP2, double thickness, PrecisionPoint result1, PrecisionPoint result2) {
        result1.setLocation(p1);
        result2.setLocation(p2);
        if (p1.equals((Object)p2)) {
            return;
        }
        result1.move(result2, amountFromP1ToP2);
        result2.setLocation(result1);
        double width = (double)this.getLineWidth() * thickness * (1.0 - amountFromP1ToP2) + (double)this.getLineWidth() * amountFromP1ToP2;
        double dx = p2.x - p1.x;
        double dy = p2.y - p1.y;
        double d = Math.hypot(dx, dy);
        double e = width / 2.0 / d;
        result1.translate(-(dy *= e), dx *= e);
        result2.translate(dy, -dx);
    }
}

