/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.commands;

import java.util.Set;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.xmind.core.ICloneData;
import org.xmind.core.IControlPoint;
import org.xmind.core.IRelationship;
import org.xmind.core.IRelationshipEnd;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.gef.IViewer;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.part.IPart;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.commands.CommandBuilder;
import org.xmind.ui.commands.CreateSheetCommand;
import org.xmind.ui.commands.ModifyTopicHyperlinkCommand;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.editor.WorkbookEditorInput;
import org.xmind.ui.mindmap.ITopicPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateSheetCommandBuilder
extends CommandBuilder {
    private IViewer viewer;
    private ITopic topic;
    private IWorkbook workbook;

    public CreateSheetCommandBuilder(IGraphicalEditor editor, IViewer viewer, ICommandStack commandStack) {
        super(viewer, commandStack);
        this.viewer = viewer;
        this.init(editor);
    }

    private void init(IGraphicalEditor editor) {
        IPart focusedPart = this.viewer.getFocusedPart();
        if (focusedPart instanceof ITopicPart) {
            ITopicPart part = (ITopicPart)focusedPart;
            this.topic = part.getTopic();
        }
        if (editor != null) {
            IEditorInput input;
            this.workbook = (IWorkbook)editor.getAdapter(IWorkbook.class);
            if (this.workbook == null && (input = editor.getEditorInput()) instanceof WorkbookEditorInput) {
                this.workbook = ((WorkbookEditorInput)input).getContents();
            }
        }
    }

    public void addCommand() {
        ISheet ownedSheet;
        Set relationships;
        String structure;
        CreateSheetCommand command = new CreateSheetCommand(this.workbook, this.topic);
        this.add((Command)command, true);
        ISheet sheet = (ISheet)command.getSource();
        if (sheet == null) {
            return;
        }
        ICloneData cloneData = command.getCloneData();
        sheet.setTitleText(NLS.bind((String)MindMapMessages.TitleText_Sheet, (Object)sheet.getParent().getSheets().size()));
        String hyper = this.topic.getHyperlink();
        ITopic rootTopic = sheet.getRootTopic();
        if (hyper == null) {
            String rootTopicId = "xmind:#" + rootTopic.getId();
            ModifyTopicHyperlinkCommand command2 = new ModifyTopicHyperlinkCommand(this.topic, rootTopicId);
            this.add((Command)command2, false);
            String newRootTopicId = "xmind:#" + this.topic.getId();
            ModifyTopicHyperlinkCommand command3 = new ModifyTopicHyperlinkCommand(rootTopic, newRootTopicId);
            this.add((Command)command3, false);
        }
        if ((structure = this.newStructure(this.topic)) != null) {
            rootTopic.setStructureClass(structure);
        }
        if ((relationships = (ownedSheet = this.topic.getOwnedSheet()).getRelationships()).size() > 0) {
            this.addRelations(relationships, sheet, cloneData);
        }
    }

    private void addRelations(Set<IRelationship> relationships, ISheet sheet, ICloneData cloneData) {
        for (IRelationship relationship : relationships) {
            String end1Id = relationship.getEnd1Id();
            String end2Id = relationship.getEnd2Id();
            String id1 = (String)cloneData.get((Object)end1Id);
            String id2 = (String)cloneData.get((Object)end2Id);
            if (id1 == null || id2 == null) continue;
            ITopic topic1 = this.workbook.findTopic(id1);
            ITopic topic2 = this.workbook.findTopic(id2);
            this.createNewRelationship(sheet, relationship, topic1, topic2);
        }
    }

    private void createNewRelationship(ISheet sheet, IRelationship relationship, ITopic topic1, ITopic topic2) {
        if (topic1 == null || topic2 == null) {
            return;
        }
        IRelationship newRelationship = this.workbook.createRelationship((IRelationshipEnd)topic1, (IRelationshipEnd)topic2);
        this.decorateRelationship(relationship, newRelationship);
        sheet.addRelationship(newRelationship);
    }

    private void decorateRelationship(IRelationship oldRelationship, IRelationship newRelationship) {
        IControlPoint oldPoint0 = oldRelationship.getControlPoint(0);
        IControlPoint newPoint0 = newRelationship.getControlPoint(0);
        newPoint0.setPolarAmount(oldPoint0.getPolarAmount());
        newPoint0.setPolarAngle(oldPoint0.getPolarAngle());
        newPoint0.setPosition(oldPoint0.getPosition());
        IControlPoint oldPoint1 = oldRelationship.getControlPoint(1);
        IControlPoint newPoint1 = newRelationship.getControlPoint(1);
        newPoint1.setPolarAmount(oldPoint1.getPolarAmount());
        newPoint1.setPolarAngle(oldPoint1.getPolarAngle());
        newPoint1.setPosition(oldPoint1.getPosition());
        newRelationship.setStyleId(oldRelationship.getStyleId());
        newRelationship.setTitleText(oldRelationship.getTitleText());
    }

    private String newStructure(ITopic topic) {
        String structure = topic.getStructureClass();
        if (structure != null && structure.contains("floating.")) {
            int index = structure.indexOf("floating.");
            int lastIndex = structure.lastIndexOf(46);
            structure = String.valueOf(structure.substring(0, index)) + structure.substring(lastIndex + 1);
        }
        return structure;
    }
}

