/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spreadsheet.structures;

import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.xmind.gef.draw2d.graphics.GraphicsUtils;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnHead
implements Comparable<ColumnHead> {
    private static final Collection<String> EMPTY_LABELS = Collections.emptyList();
    public static final ColumnHead EMPTY = new ColumnHead(EMPTY_LABELS);
    private Collection<String> labels;
    private String text;
    private Font font;
    private Dimension prefSize;

    public ColumnHead(Collection<String> labels) {
        this.labels = new TreeSet<String>(labels);
    }

    public ColumnHead(String text) {
        this.labels = new TreeSet<String>(MindMapUtils.getLabels((String)text));
    }

    public Collection<String> getLabels() {
        return this.labels;
    }

    public boolean isEmpty() {
        return this.labels.isEmpty();
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = this.calcFont();
        }
        return this.font;
    }

    private Font calcFont() {
        return JFaceResources.getDefaultFont();
    }

    public Dimension getPrefSize() {
        if (this.prefSize == null) {
            this.prefSize = this.calcPrefSize();
        }
        return this.prefSize;
    }

    private Dimension calcPrefSize() {
        String s = this.toString();
        if ("".equals(s)) {
            s = "X";
        }
        return GraphicsUtils.getAdvanced().getTextSize(s, this.getFont());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ColumnHead)) {
            return false;
        }
        ColumnHead that = (ColumnHead)obj;
        return this.labels.size() == that.labels.size() && this.labels.containsAll(that.labels);
    }

    public int hashCode() {
        return this.labels.hashCode();
    }

    public String toString() {
        if (this.text == null) {
            this.text = this.createText();
        }
        return this.text;
    }

    private String createText() {
        return MindMapUtils.getLabelText(this.labels);
    }

    @Override
    public int compareTo(ColumnHead o) {
        if (this.isEmpty()) {
            return 1;
        }
        if (o.isEmpty()) {
            return -1;
        }
        return this.toString().compareTo(o.toString());
    }
}

