/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spreadsheet;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.Request;
import org.xmind.gef.part.IPart;
import org.xmind.ui.internal.spreadsheet.ColumnHeadEditorHelper;
import org.xmind.ui.internal.spreadsheet.structures.Cell;
import org.xmind.ui.internal.spreadsheet.structures.Chart;
import org.xmind.ui.internal.spreadsheet.structures.Column;
import org.xmind.ui.internal.spreadsheet.structures.ColumnHead;
import org.xmind.ui.internal.spreadsheet.structures.Item;
import org.xmind.ui.internal.spreadsheet.structures.Row;
import org.xmind.ui.internal.tools.LabelProposalProvider;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.texteditor.ContentProposalAdapter;
import org.xmind.ui.texteditor.FloatingTextEditor;
import org.xmind.ui.texteditor.FloatingTextEditorContentAssistAdapter;
import org.xmind.ui.tools.MindMapEditToolBase;

public class ColumnHeadEditTool
extends MindMapEditToolBase {
    private Chart chart;
    private ColumnHead columnHead;
    private Column column;
    private ColumnHeadEditorHelper helper;
    protected ContentProposalAdapter contentProposalAdapter = null;

    public void setChart(Chart chart) {
        Assert.isNotNull((Object)((Object)chart));
        this.chart = chart;
    }

    public void setColumnHead(ColumnHead columnHead) {
        Assert.isNotNull((Object)columnHead);
        this.columnHead = columnHead;
    }

    public void setColumn(Column column) {
        Assert.isNotNull((Object)column);
        this.column = column;
    }

    protected String getInitialText(IPart source) {
        Assert.isNotNull((Object)this.columnHead);
        Assert.isNotNull((Object)this.column);
        return this.columnHead.toString();
    }

    protected Request createTextRequest(IPart source, IDocument document) {
        if (this.column == null) {
            return null;
        }
        if (this.isColumnEmpty()) {
            Request request = new Request("create child");
            request.setParameter("property.labels", (Object)document.get());
            for (Cell cell : this.column.getCells()) {
                Row row = cell.getOwnedRow();
                if (row == null) continue;
                request.setPrimaryTarget((IPart)row.getHead());
                return request;
            }
            return null;
        }
        Request request = new Request("modify label");
        request.setParameter("text", (Object)document.get());
        ArrayList<ITopicPart> targets = new ArrayList<ITopicPart>();
        for (Cell cell : this.column.getCells()) {
            for (Item item : cell.getItems()) {
                targets.add(item.getBranch().getTopicPart());
            }
        }
        request.setTargets(targets);
        return request;
    }

    private boolean isColumnEmpty() {
        if (!this.column.getHead().isEmpty()) {
            return false;
        }
        for (Cell cell : this.column.getCells()) {
            if (cell.getItems().isEmpty()) continue;
            return false;
        }
        return true;
    }

    protected void hookEditor(FloatingTextEditor editor) {
        super.hookEditor(editor);
        if (this.helper == null) {
            this.helper = new ColumnHeadEditorHelper(true);
        }
        this.helper.setEditor(editor);
        this.helper.setViewer(this.getTargetViewer());
        this.helper.setChart(this.chart);
        this.helper.setColumn(this.column);
        this.helper.setColumnHead(this.columnHead);
        this.helper.activate();
    }

    protected void unhookEditor(FloatingTextEditor editor) {
        if (this.helper != null) {
            this.helper.deactivate();
        }
        super.unhookEditor(editor);
    }

    protected void hookEditorControl(FloatingTextEditor editor, ITextViewer textViewer) {
        super.hookEditorControl(editor, textViewer);
        LabelProposalProvider proposalProvider = new LabelProposalProvider((IPart)this.getSource());
        if (this.contentProposalAdapter == null) {
            this.contentProposalAdapter = new FloatingTextEditorContentAssistAdapter(editor, (IContentProposalProvider)proposalProvider);
            this.contentProposalAdapter.setProposalAcceptanceStyle(2);
            this.contentProposalAdapter.setPopupSize(new Point(180, 80));
            final Image labelImage = this.createLabelProposalImage();
            if (labelImage != null) {
                this.contentProposalAdapter.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public Image getImage(Object element) {
                        return labelImage;
                    }
                });
            }
            editor.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ColumnHeadEditTool.this.contentProposalAdapter.setLabelProvider(null);
                    ColumnHeadEditTool.this.contentProposalAdapter = null;
                    if (labelImage != null) {
                        labelImage.dispose();
                    }
                }
            });
        } else {
            this.contentProposalAdapter.setContentProposalProvider((IContentProposalProvider)proposalProvider);
        }
    }

    private Image createLabelProposalImage() {
        return MindMapUI.getImages().get("label.gif", true).createImage(false, (Device)Display.getCurrent());
    }
}

